<?php
session_start();
if (!isset($_SESSION['username'])) {
    header("Location: index.php"); // Redirect to login page if not logged in
    exit();
}
include("db_config.php");
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Dashboard -  </title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="assets/img/favicon.png" rel="icon">
  <link href="assets/img/apple-touch-icon.png" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link
    href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i"
    rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">
</head>
<style>
  /* Card Hover Animation */
  .card-hover {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
  }

  .card-hover:hover {
    transform: scale(1.05);
    box-shadow: 0px 10px 20px rgba(0, 0, 0, 0.2);
  }

  /* Icon Bounce Animation */
  .icon-hover {
    transition: transform 0.3s ease-in-out;
  }

  .card-hover:hover .icon-hover {
    transform: translateY(-5px);
  }
</style>



<body>

  <!-- ======= Header ======= -->
  <header id="header" class="header fixed-top d-flex align-items-center">

    <div class="d-flex align-items-center justify-content-between">
      <a href="index.php" class="logo d-flex align-items-center">
        <img src="assets/img/logo.png" alt="">
        <span class="d-none d-lg-block">ScApps</span>
      </a>
      <i class="bi bi-list toggle-sidebar-btn"></i>
    </div><!-- End Logo -->

    <div class="search-bar">
      <form class="search-form d-flex align-items-center" method="POST" action="#">
        <input type="text" name="query" placeholder="Search" title="Enter search keyword">
        <button type="submit" title="Search"><i class="bi bi-search"></i></button>
      </form>
    </div><!-- End Search Bar -->

    <nav class="header-nav ms-auto">
      <ul class="d-flex align-items-center">

        <li class="nav-item d-block d-lg-none">
          <a class="nav-link nav-icon search-bar-toggle " href="#">
            <i class="bi bi-search"></i>
          </a>
        </li><!-- End Search Icon-->


      </ul>
    </nav><!-- End Icons Navigation -->

  </header><!-- End Header -->

   <!-- ======= Sidebar ======= -->
   <aside id="sidebar" class="sidebar">

<ul class="sidebar-nav" id="sidebar-nav">

  <li class="nav-item">
    <a class="nav-link " href="dashboard.php">
      <i class="bi bi-grid"></i>
      <span>Dashboard</span>
    </a>
  </li><!-- End Dashboard Nav -->

  <li class="nav-item">
  <a class="nav-link " href="advertiser.php">
      <i class="bi bi-layout-text-window-reverse"></i><span>Advertiser</span>
    </a>
  </li><!-- End Tables Nav -->


  <li class="nav-item">
  <a class="nav-link " href="app.php">
      <i class="bi bi-layout-text-window-reverse"></i><span>Ads</span>
    </a>
  </li><!-- End Tables Nav -->



<!-- End Profile Page Nav -->

  

  
  <li class="nav-item">
    <a class="nav-link collapsed" href="logout.php">
      <i class="bi bi-box-arrow-in-right"></i>
      <span>Logout</span>
    </a>
  </li>
</ul>

</aside><!-- End Sidebar-->

  <main id="main" class="main">
  <div class="pagetitle">
  <h1>News App Dashboard</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="dashboard.html">Home</a></li>
      <li class="breadcrumb-item active">News Dashboard</li>
    </ol>
  </nav>
</div><!-- End Page Title -->

<section class="section dashboard">
  <div class="row">

    <!-- Left side columns -->
    <div class="col-lg-12">
      <div class="row">
        <!-- Navigation -->
        <nav>
          <ul>
            <li><a id="newsLink" href="#">News</a></li>
          </ul>
        </nav>

        <div class="container">
          <div class="row g-4">
            <!-- Add Category Card -->
            <div class="col-12 col-md-6">
              <a href="categories.php" class="text-decoration-none">
                <div class="card shadow-lg border-0 rounded-4 h-100 card-hover">
                  <div class="card-body text-center">
                    <div class="card-icon bg-primary text-white rounded-circle d-flex align-items-center justify-content-center mx-auto mt-4 icon-hover" style="width: 60px; height: 60px;">
                      <i class="bi bi-bookmark-plus fs-3"></i>
                    </div>
                    <h3 class="mt-3 text-dark">Add Category</h3>
                    <p class="text-muted">Create new content categories and manage existing ones.</p>
                  </div>
                </div>
              </a>
            </div>

            <!-- Manage Articles Card -->
            <div class="col-12 col-md-6">
              <a href="articles.php" class="text-decoration-none">
                <div class="card shadow-lg border-0 rounded-4 h-100 card-hover">
                  <div class="card-body text-center">
                    <div class="card-icon bg-success text-white rounded-circle d-flex align-items-center justify-content-center mx-auto mt-4 icon-hover" style="width: 60px; height: 60px;">
                      <i class="bi bi-newspaper fs-3"></i>
                    </div>
                    <h3 class="mt-3 text-dark">Manage Articles</h3>
                    <p class="text-muted">Create, edit, and monitor news article performance.</p>
                  </div>
                </div>
              </a>
            </div>
          </div>
        </div>

        <!-- User Engagement Summary Card -->
        <div class="col-xxl-12 col-md-6 col-lg-12 mt-5">
          <div class="card info-card engagement-card">
            <div class="card-body">
              <h5 class="card-title">User Engagement <span>| Total</span></h5>
              <div class="d-flex align-items-center">
                <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                  <i class="bi bi-eye"></i>
                </div>
                <div class="ps-3">
                  <h6 id="readCount">0</h6>
                  <span class="text-success small pt-1 fw-bold">12%</span>
                  <span class="text-muted small pt-2 ps-1">increase</span>
                  <div>Total Reads: 150,000</div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <!-- Reads by Country Card -->
        <div class="col-xxl-6 col-md-6 col-lg-6">
          <div class="card info-card country-reads-card">
            <div class="card-body">
              <h5 class="card-title">Reads by Country <span>| This Month</span></h5>
              <div id="countryReadsChart" style="min-height: 400px;" class="echart"></div>
              <script>
                document.addEventListener("DOMContentLoaded", () => {
                  echarts.init(document.querySelector("#countryReadsChart")).setOption({
                    tooltip: { trigger: 'item' },
                    legend: { top: '5%', left: 'center' },
                    series: [{
                      name: 'Country Reads',
                      type: 'pie',
                      radius: ['40%', '70%'],
                      data: [
                        { value: 1548, name: 'USA' },
                        { value: 935, name: 'India' },
                        { value: 780, name: 'UK' },
                        { value: 684, name: 'Germany' },
                        { value: 450, name: 'Japan' }
                      ]
                    }]
                  });
                });
              </script>
            </div>
          </div>
        </div><!-- End Reads by Country Card -->

        <!-- Reads Over Time Card -->
        <div class="col-xxl-6 col-md-6 col-lg-6">
          <div class="card info-card reads-time-card">
            <div class="card-body">
              <h5 class="card-title">Reads Over Time <span>| This Month</span></h5>
              <div id="readsOverTimeChart"></div>
              <script>
                document.addEventListener("DOMContentLoaded", () => {
                  new ApexCharts(document.querySelector("#readsOverTimeChart"), {
                    series: [{ name: 'Reads', data: [45, 60, 75, 90, 110, 130, 150] }],
                    chart: { height: 350, type: 'line' },
                    stroke: { curve: 'smooth' },
                    markers: { size: 4 },
                    colors: ['#2eca6a'],
                    xaxis: { categories: ['1', '2', '3', '4', '5', '6', '7'] },
                    tooltip: { x: { format: 'dd/MM/yy' } }
                  }).render();
                });
              </script>
            </div>
          </div>
        </div><!-- End Reads Over Time Card -->

      </div>
    </div><!-- End Left side columns -->

    <!-- Right side columns -->
    <div class="col-lg-12">
      <!-- Subscription Rate Card -->
      <div class="card">
        <div class="card-body">
          <h5 class="card-title">Subscription Rate</h5>
          <h6 class="text-center">Free to Premium Conversion: <span class="text-success">8.7%</span></h6>
          <div class="progress">
            <div class="progress-bar" role="progressbar" style="width: 87%" aria-valuenow="87" aria-valuemin="0" aria-valuemax="100"></div>
          </div>
        </div>
      </div><!-- End Subscription Rate Card -->
    </div><!-- End Right side columns -->

  </div>
</section>

<script>
  document.addEventListener("DOMContentLoaded", function () {
    let readCount = localStorage.getItem("newsReads") || 0;
    document.getElementById("readCount").innerText = readCount;

    document.getElementById("newsLink").addEventListener("click", function () {
      readCount++;
      localStorage.setItem("newsReads", readCount);
      document.getElementById("readCount").innerText = readCount;
    });
  });
</script>
</main><!-- End #main -->


  <!-- ======= Footer ======= -->
  <footer id="footer" class="footer">
    <div class="copyright">
      &copy; Copyright <strong><span>CodingSuresh</span></strong>. All Rights Reserved
    </div>
    <div class="credits">

      Designed by <a href="#">CodingSuresh</a>
    </div>
  </footer><!-- End Footer -->

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i
      class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/quill/quill.js"></script>
  <script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
  <script src="assets/vendor/tinymce/tinymce.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>

  <!-- Template Main JS File -->
  <script src="assets/js/main.js"></script>

</body>

</html>